"use strict";
exports.id = 102;
exports.ids = [102];
exports.modules = {

/***/ 102:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _context_contextStatus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2257);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1185);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _common_LoadingSubmit__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2969);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3590);
/* harmony import */ var _lib_postRequest__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6259);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, react_toastify__WEBPACK_IMPORTED_MODULE_6__, _lib_postRequest__WEBPACK_IMPORTED_MODULE_7__]);
([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, react_toastify__WEBPACK_IMPORTED_MODULE_6__, _lib_postRequest__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const FeedbackModal = ({ feedbackModalOpen , setFeedbackModalOpen , orderId  })=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
    const { name , token , phone , setName , setPhone , userId , email , setEmail  } = (0,_context_contextStatus__WEBPACK_IMPORTED_MODULE_1__/* .useStatus */ .$)();
    const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
    const [invoice, setInvoice] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)("");
    const [type, setType] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)("");
    const [comments, setComments] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)("");
    const handleSubmit = async ()=>{
        if (!token && invoice == "") {
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.error(" Invoice no. is required");
            return;
        }
        if (name == "") {
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.error(" Name is required");
            return;
        }
        if (phone == "") {
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.error(" Phone is required");
            return;
        }
        if (phone) {
            var bdMobilePattern = /^(\+)?(88)?01[3-9]\d{8}$/;
            if (bdMobilePattern.test(phone)) {} else {
                react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.error("Not a valid phone number");
                return;
            }
        }
        if (type == "") {
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.error("Type is required");
            return;
        }
        if (comments == "") {
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.error("Feedback is required");
            return;
        }
        setLoading(true);
        const res = await (0,_lib_postRequest__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)(`order-feedback`, {
            customer_id: userId,
            invoice_no: !token ? invoice : orderId,
            email: email,
            name: name,
            phone: phone,
            type: type,
            feedback: comments
        });
        if (res?.success) {
            setLoading(false);
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.success(`${res?.message}`);
            setType("");
            setComments("");
        } else {
            react_toastify__WEBPACK_IMPORTED_MODULE_6__.toast.error(`${res?.message}`);
            setLoading(false);
        }
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Transition, {
        appear: true,
        show: feedbackModalOpen,
        as: react__WEBPACK_IMPORTED_MODULE_4__.Fragment,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Dialog, {
            as: "div",
            className: "fixed inset-0 z-9999 overflow-y-auto bg-opacity-60 bg-black dark:text-black",
            onClose: ()=>setFeedbackModalOpen(false),
            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: " min-h-screen px-4 text-center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Transition.Child, {
                        as: react__WEBPACK_IMPORTED_MODULE_4__.Fragment,
                        enter: "ease-out duration-500",
                        enterFrom: "opacity-0",
                        enterTo: "opacity-100",
                        leave: "ease-in duration-500",
                        leaveFrom: "opacity-100",
                        leaveTo: "opacity-0",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Dialog.Overlay, {
                            className: "fixed inset-0"
                        })
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                        className: "inline-block h-screen align-middle",
                        "aria-hidden": "true",
                        children: "​"
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Transition.Child, {
                        as: react__WEBPACK_IMPORTED_MODULE_4__.Fragment,
                        enter: "ease-out duration-500 translate-y-0",
                        enterFrom: "opacity-0 duration-300 scale-95 translate-y-0",
                        enterTo: "opacity-100 scale-100",
                        leave: "ease-in duration-300",
                        leaveFrom: "opacity-100 scale-100",
                        leaveTo: "opacity-0 scale-95",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "inline-block w-full max-w-[600px] min-h-[300px] p-4 xls:p-2 xms:p-2 xs:p-1 my-8 overflow-hidden text-left align-middle transition-all transform bg-gray-100 rounded-lg shadow-xl",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                    className: "py-4 bg-gray-100 flex flex-col justify-center max-w-[45rem] mx-auto",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "sm:mx-auto sm:w-full sm:max-w-md",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "text-center text-3xl font-extrabold text-gray-900 relative",
                                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                    className: "absolute top-[-20px] right-[-5px]",
                                                    onClick: ()=>setFeedbackModalOpen(false),
                                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
                                                        className: "fill-current text-red-500 cursor-pointer",
                                                        xmlns: "http://www.w3.org/2000/svg",
                                                        viewBox: "0 0 24 24",
                                                        width: "28",
                                                        height: "28",
                                                        children: [
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                                                fill: "none",
                                                                d: "M0 0h24v24H0z"
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
                                                                d: "M12 10.586l4.95-4.95 1.414 1.414-4.95 4.95 4.95 4.95-1.414 1.414-4.95-4.95-4.95 4.95-1.414-1.414 4.95-4.95-4.95-4.95L7.05 5.636z"
                                                            })
                                                        ]
                                                    })
                                                })
                                            }),
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                className: "mt-4 text-black space-y-3",
                                                children: [
                                                    !token ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                        children: [
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                                                                className: "text-sm",
                                                                children: "Invoice No"
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                                type: "text",
                                                                className: " w-full border border-gray-300 pl-2 py-2 rounded-md dark:bg-white text-black text-sm  focus:outline-none",
                                                                placeholder: "Enter invoice no",
                                                                value: invoice,
                                                                onChange: (e)=>setInvoice(e.target.value)
                                                            })
                                                        ]
                                                    }) : null,
                                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                        children: [
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                                                                className: "text-sm",
                                                                children: "Name"
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                                type: "text",
                                                                value: name,
                                                                readOnly: token ? true : false,
                                                                className: " w-full border border-gray-300 pl-2 py-2 rounded-md dark:bg-white text-black text-sm  focus:outline-none",
                                                                placeholder: "Enter name",
                                                                onChange: (e)=>setName(e.target.value)
                                                            })
                                                        ]
                                                    }),
                                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                        children: [
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                                                                className: "text-sm",
                                                                children: "Phone number"
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                                type: "text",
                                                                className: " w-full border border-gray-300 pl-2 py-2 rounded-md dark:bg-white text-black text-sm  focus:outline-none",
                                                                placeholder: "Enter phone",
                                                                value: phone,
                                                                readOnly: token ? true : false,
                                                                onChange: (e)=>setPhone(e.target.value)
                                                            })
                                                        ]
                                                    }),
                                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                        className: "w-full",
                                                        children: [
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                                                className: "text-lg font-normal  py-2 text-black",
                                                                children: "Email"
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                                                className: "border-[1px] h-[40px] w-full pl-2 rounded-md outline-none bg-white text-black",
                                                                placeholder: "Enter name...",
                                                                defaultValue: email,
                                                                onChange: (event)=>setEmail(event.target.value)
                                                            })
                                                        ]
                                                    }),
                                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                        children: [
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                                                                className: "text-sm",
                                                                children: "Type"
                                                            }),
                                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("select", {
                                                                className: "bg-gray-50 border border-gray-300 text-gray-900 outline-none text-sm rounded-lg block w-full xls:w-full xms:w-full xs:w-full p-2.5 dark:bg-white dark:placeholder-gray-400 dark:text-black",
                                                                onChange: (e)=>setType(e.target.value),
                                                                children: [
                                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                                        disabled: true,
                                                                        children: "Select type"
                                                                    }),
                                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                                        value: "1",
                                                                        children: "Delivery"
                                                                    }),
                                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("option", {
                                                                        value: "2",
                                                                        children: "Communication"
                                                                    })
                                                                ]
                                                            })
                                                        ]
                                                    }),
                                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                        children: [
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("label", {
                                                                className: "text-sm",
                                                                children: "Comments"
                                                            }),
                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("textarea", {
                                                                rows: "4",
                                                                className: "block mt-2 p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border-2 border-deepBlue-800 outline-none  dark:bg-white  dark:text-black",
                                                                placeholder: "Write your thoughts here...",
                                                                value: comments,
                                                                onChange: (e)=>setComments(e.target.value)
                                                            })
                                                        ]
                                                    }),
                                                    loading ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                        className: "flex justify-start mt-4",
                                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_common_LoadingSubmit__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {})
                                                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                        className: "mt-4 flex justify-start",
                                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                                            className: "px-4 py-1  rounded-md text-white bg-deepBlue-800 ",
                                                            onClick: ()=>handleSubmit(),
                                                            children: "Submit"
                                                        })
                                                    })
                                                ]
                                            })
                                        ]
                                    })
                                })
                            })
                        })
                    })
                ]
            })
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeedbackModal);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;