"use strict";
exports.id = 349;
exports.ids = [349];
exports.modules = {

/***/ 2349:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lib_config__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(9159);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_ai__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9847);
/* harmony import */ var react_icons_ai__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_ai__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _context_contextStatus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2257);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5675);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_image__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_icons_bs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(567);
/* harmony import */ var react_icons_bs__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_icons_bs__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6652);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_icons_bi__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_icons_tb__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(4152);
/* harmony import */ var react_icons_tb__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_icons_tb__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(3053);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(nookies__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(3590);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_toastify__WEBPACK_IMPORTED_MODULE_10__]);
react_toastify__WEBPACK_IMPORTED_MODULE_10__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];














const ProductCard = ({ item , index , products  })=>{
    const { cartItems , setCartItems , setIsRenderMe , renderMe , setPromoValue , setCouponId  } = (0,_context_contextStatus__WEBPACK_IMPORTED_MODULE_3__/* .useStatus */ .$)();
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_5__.useRouter)();
    const [isOptimizedImage, setIsOptimizedImage] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
    const [buttonModal, setButtonModal] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const containerRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const handleClick = (slug)=>{
        router.push(`/product/${slug}`);
    };
    const handleClickOutside = (event)=>{
        if (containerRef.current && !containerRef.current.contains(event.target)) {
            setButtonModal(false);
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        // Add event listener to detect clicks outside the component
        document.addEventListener("mousedown", handleClickOutside);
        return ()=>{
            // Cleanup event listener on component unmount
            document.removeEventListener("mousedown", handleClickOutside);
        };
    }, []);
    const handleCart = (index)=>{
        setButtonModal((prev)=>!prev);
        let obj = {
            id: item?.product_units[0]?.id,
            product_id: item?.id,
            name: item?.name,
            image: item?.image,
            generic_name: item?.generic?.generic_name,
            quantity: 1,
            price: item?.product_units[0]?.discount == 0 || item?.product_units[0]?.discount == null ? item?.product_units[0]?.price : Number(item?.product_units[0]?.price - item?.product_units[0]?.price * item?.product_units[0]?.discount / 100).toFixed(2),
            stock: item?.product_units[0]?.qty,
            productUnit: item?.product_units,
            unitName: item?.product_units[0]?.unit?.unit_name,
            slug: item?.slug,
            mainprice: item?.product_units[0]?.price,
            discount: Number(item?.product_units[0]?.discount),
            sale_unit_id: item?.product_units[0]?.unit?.id
        };
        const is_exist = cartItems.find((variation)=>variation.product_id == obj.product_id);
        if (is_exist === undefined) {
            setCartItems((cartItems)=>[
                    ...cartItems,
                    obj
                ]);
            (0,nookies__WEBPACK_IMPORTED_MODULE_9__.setCookie)(null, "ePharma", JSON.stringify([
                ...cartItems,
                obj
            ]), {
                maxAge: 30 * 24 * 60 * 60,
                path: "/"
            });
            setPromoValue(null);
            (0,nookies__WEBPACK_IMPORTED_MODULE_9__.destroyCookie)(null, "promovalue", {
                path: "/"
            });
            setCouponId("");
            (0,nookies__WEBPACK_IMPORTED_MODULE_9__.destroyCookie)(null, "couponid", {
                path: "/"
            });
            setIsRenderMe(!renderMe);
            react_toastify__WEBPACK_IMPORTED_MODULE_10__.toast.success("Product Added");
        }
    };
    const handleDecrement = ()=>{
        const index = cartItems.findIndex((variation)=>variation.product_id === item?.id);
        const updatedCartItems = cartItems.map((item, idx)=>{
            if (idx === index) {
                return {
                    ...item,
                    quantity: item.quantity - 1
                };
            }
            return item;
        });
        setCartItems(updatedCartItems);
        (0,nookies__WEBPACK_IMPORTED_MODULE_9__.setCookie)(null, "ePharma", JSON.stringify(updatedCartItems), {
            maxAge: 30 * 24 * 60 * 60,
            path: "/"
        });
    };
    const handleIncrement = ()=>{
        const index = cartItems.findIndex((variation)=>variation.product_id === item?.id);
        const updatedCartItems = cartItems.map((item, idx)=>{
            if (idx === index) {
                return {
                    ...item,
                    quantity: item.quantity + 1
                };
            }
            return item;
        });
        setCartItems(updatedCartItems);
        (0,nookies__WEBPACK_IMPORTED_MODULE_9__.setCookie)(null, "ePharma", JSON.stringify(updatedCartItems), {
            maxAge: 30 * 24 * 60 * 60,
            path: "/"
        });
    };
    const handleDelete = ()=>{
        const index = cartItems.findIndex((variation)=>variation.product_id === item?.id);
        const updatedCartItems = cartItems.filter((_, idx)=>idx !== index);
        setCartItems(updatedCartItems);
        (0,nookies__WEBPACK_IMPORTED_MODULE_9__.setCookie)(null, "ePharma", JSON.stringify(updatedCartItems), {
            maxAge: 30 * 24 * 60 * 60,
            path: "/"
        });
        setButtonModal(false);
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
            className: "cursor-pointer",
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: " group rounded-md items-center justify-center card-shadow  font-body border border-gray-200",
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    className: "relative",
                    children: [
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: " h-[200px]  p-3 xs:h-auto xms:h-[180px]  rounded-md  relative",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_image__WEBPACK_IMPORTED_MODULE_4___default()), {
                                    src: isOptimizedImage ? `${_lib_config__WEBPACK_IMPORTED_MODULE_11__/* .ImageHostName */ .G}/storage/product/${item?.image}` : "/image/placeholder_600x.webp",
                                    className: "h-full w-full object-contain group-hover:scale-110 ease-in-out duration-500",
                                    height: 500,
                                    width: 500,
                                    priority: true,
                                    onClick: ()=>handleClick(item?.slug),
                                    unoptimized: !isOptimizedImage,
                                    onError: ()=>setIsOptimizedImage(false),
                                    alt: "product"
                                }),
                                buttonModal ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                    ref: containerRef,
                                    className: `absolute bottom-2 right-3  ${buttonModal ? "w-[100px]" : "w-0"} overflow-hidden flex items-center justify-center bg-white border border-gray-200 py-1 px-2 rounded-full outline-none`,
                                    children: [
                                        cartItems[cartItems.findIndex((variation)=>variation.product_id === item?.id)]?.quantity > 1 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                            onClick: ()=>handleDecrement(),
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_7__.BiMinus, {
                                                size: 15,
                                                color: "#000",
                                                className: "font-semibold"
                                            })
                                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                            onClick: ()=>handleDelete(),
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_icons_tb__WEBPACK_IMPORTED_MODULE_8__.TbTrash, {
                                                size: 20,
                                                color: "#000",
                                                className: "font-semibold"
                                            })
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("input", {
                                            type: "text",
                                            value: cartItems[cartItems.findIndex((variation)=>variation.product_id === item?.id)].quantity,
                                            className: "w-full text-center bg-white text-black font-semibold outline-none"
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("button", {
                                            onClick: ()=>handleIncrement(index),
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_6__.BsPlusLg, {
                                                size: 15,
                                                color: "#000",
                                                className: "font-semibold"
                                            })
                                        })
                                    ]
                                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                        className: "absolute bottom-2 right-3",
                                        onClick: ()=>handleCart(),
                                        children: cartItems[cartItems.findIndex((variation)=>variation.product_id === item?.id)]?.quantity > 1 ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            className: "bg-gray-600 text-white rounded-full h-[25px] w-[25px] flex justify-center items-center text-sm",
                                            children: [
                                                " ",
                                                cartItems[cartItems.findIndex((variation)=>variation.product_id === item?.id)].quantity
                                            ]
                                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_icons_ai__WEBPACK_IMPORTED_MODULE_2__.AiFillPlusCircle, {
                                            size: 25,
                                            className: "text-deepBlue-800 cursor-pointer"
                                        })
                                    })
                                })
                            ]
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            className: "p-2",
                            onClick: ()=>handleClick(item?.slug, index, item?.id),
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                    className: "text-sm  font-semibold text-gray-700 pb-2 text-left h-[40px]",
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                        className: "line-clamp-2",
                                        children: item?.name
                                    })
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                    className: "text-gray-700 font-semibold text-sm tracking-wider pb-2 text-left line-clamp-2 h-[40px]",
                                    onClick: ()=>handleClick(item?.slug, index, item?.id),
                                    children: item?.generic?.generic_name
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                                    className: "text-gray-600 font-semibold text-xs  text-left pb-2 line-clamp-2",
                                    onClick: ()=>handleClick(item?.slug, index, item?.id),
                                    children: item?.company?.name
                                }),
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                    className: " px-1 pt-2   pb-3",
                                    children: [
                                        item?.product_units[0]?.discount == null || Number(item?.product_units[0]?.discount) == 0 ? null : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                            className: "text-sm  text-gray-400 font-semibold line-through",
                                            children: [
                                                "৳ ",
                                                Number(item?.product_units[0]?.price).toFixed(2)
                                            ]
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                            className: "flex space-x-2 items-center",
                                            children: [
                                                item?.product_units[0]?.discount !== null ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                                    className: "text-base xms:text-sm xs:text-xs  text-gray-700 font-semibold",
                                                    children: [
                                                        "৳",
                                                        " ",
                                                        Number(item?.product_units[0]?.price - item?.product_units[0]?.price * item?.product_units[0]?.discount / 100).toFixed(2)
                                                    ]
                                                }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("p", {
                                                    className: "text-base xms:text-sm xs:text-xs  text-gray-700 font-semibold",
                                                    children: [
                                                        " ",
                                                        Number(item?.product_units[0]?.price).toFixed(2)
                                                    ]
                                                }),
                                                item?.product_units[0]?.discount == null || Number(item?.product_units[0]?.discount) == 0 ? null : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("button", {
                                                        className: "text-base xms:text-sm xs:text-xs  font-semibold rounded-md text-red-400",
                                                        children: [
                                                            "(",
                                                            item?.product_units[0]?.discount,
                                                            "% )"
                                                        ]
                                                    })
                                                })
                                            ]
                                        })
                                    ]
                                })
                            ]
                        })
                    ]
                })
            })
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductCard);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;