module.exports = {
  content: [
    "./app/**/*.{js,ts,jsx,tsx}",
    "./pages/**/*.{js,ts,jsx,tsx}",
    "./components/**/*.{js,ts,jsx,tsx}",

    // Or if using `src` directory:
    "./src/**/*.{js,ts,jsx,tsx}",
  ],
  theme: {
    screens: {
      xs: { min: "270px", max: "320px" },
      xms: { min: "321px", max: "375px" },
      xls: { min: "376px", max: "480px" },
      // => @media (min-width: 320px) { ... }

      sm: { min: "481px", max: "768px" },
      // => @media (min-width: 640px) { ... }
      md: { min: "769px", max: "1024px" },
      // => @media (min-width: 768px) { ... }

      lg: { min: "1025px", max: "1440px" },

      // => @media (min-width: 1024px) { ... }
      xl: { min: "1441px", max: "2500px" },
      // => @media (min-width: 1280px) { ... }
      xxl: { min: "2500px", max: "2561px" },
    },
    extend: {
      zIndex: {
        60: "60",
        9999: "9999",
      },
      colors: {
        myColor: {
          500: "#25A8D6",
        },
        secondaryColor: {
          500: "#fb923c",
        },
        lightBlue: {
          400: "#0078b4",
        },
        deepBlue: {
          800: "#333681",
        },
      },
      fontFamily: {
        body: ["Nunito", "sans-serif"],
      },
    },
  },
  plugins: [],
};
